<?php
require_once('utility.php');
function _signal_handler( $signal ) {
    switch( $signal ) {
        case SIGHUP:
            debug_print( "ReceivingSignal: signal='SIGHUP'" ) ;
            break ;
            
        case SIGINT:
            debug_print( "ReceivingSignal: signal='SIGINT'" ) ;
            break ;
            
        case SIGTERM:
            debug_print( "ReceivingSignal: signal='SIGTERM'" ) ;
            break ;
            
        default:
            break ;
    }
}

function switch_esxi_sshd( $argv ) {
    pcntl_signal( SIGHUP,  "_signal_handler" ) ;
    pcntl_signal( SIGINT,  "_signal_handler" ) ;
    pcntl_signal( SIGTERM, "_signal_handler" ) ;

	/* check number of arguments */
	if( count( $argv ) != 4 ) {
		echo "Usage: " . basename( __FILE__, ".inc" ) . " <EsxiHOST> <EsxiUsername> <EsxiPassword> [start|stop]\n" ;
		exit( 1 ) ;
	}
    
	/* check number of arguments */
	$esxi_host     = $argv[ 0 ] ;
	$esxi_username = $argv[ 1 ] ;
	$esxi_password = $argv[ 2 ] ;
	$operation     = $argv[ 3 ] ;

	/* execute main function */
    $stepName = "SwitchEsxiSshd" ;
    debug_print( "${stepName}: operation='$operation'" ) ;
    $portNumber = getEsxiPort($esxi_host);
    $ret_array = run_program_at_ms( array(
            'exit_when_error' => 0,
            'program'   => '/usr/bin/perl',
            'arguments' => array( "hostServiceManagement.pl",
                                  "--server",    $esxi_host,
                                  "--username",  $esxi_username,
                                  "--password",  $esxi_password,
                                  "--service",   "TSM-SSH",
                                  "--operation", $operation,
                                  "--portnumber", $portNumber ) ) ) ;
    $retCode = $ret_array[ 0 ] ;
    $msg     = join( "\n", $ret_array[ 1 ] ) ;
    if( $retCode != 0 ) {
        debug_print( "${stepName}Fail: ret='$retCode', msg='$msg'" ) ;
        exit( $retCode ) ;
    }
    
    debug_print( "${stepName}Pass: msg='$msg'" ) ;
	exit( 0 ) ;
}

